<?xml version="1.0" encoding="windows-1250"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="html" encoding="windows-1250" doctype-public="-//W3C//DTD HTML 4.01//EN"
            doctype-system="http://www.w3.org/TR/html4/strict.dtd"/>

<!--================================================================================================
  szablon startowy
=================================================================================================-->

<xsl:template match="/podsumowanie-hosp">

  <html>
    <head>
      <meta http-equiv="content-type" content="text/html; charset=windows-1250"/>
      <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
      <link href="res://mMedica.exe/CSS/HospWydruki" type="text/css" rel="stylesheet"/>
      <title>Podsumowanie hospitalizacji</title>
    </head>
    <body>
      <xsl:call-template name="naglowek"/>
      <xsl:choose>
        <xsl:when test="zgon">
          <xsl:call-template name="zast-lecz-uwagi"/>
          <xsl:call-template name="epikryza"/>
          <xsl:call-template name="rozpoznania-zgon"/>
          <xsl:call-template name="sekcja"/>
          <xsl:call-template name="podane-leki"/>
          <xsl:call-template name="konsultacje"/>
          <xsl:call-template name="wyniki-bad-lab"/>
          <xsl:call-template name="wyniki-bad-diag"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="rozpoznania-wyp"/>
          <xsl:call-template name="rozpoznanie-pac"/>
          <xsl:call-template name="oceny-icf"/>
          <xsl:call-template name="wyniki-bad-lab"/>
          <xsl:call-template name="wyniki-bad-diag"/>
          <xsl:call-template name="konsultacje"/>
          <xsl:call-template name="zabieg">
            <xsl:with-param name="value" select="zabieg"/>
            <xsl:with-param name="header" select="'Zabieg'"/>
          </xsl:call-template>
          <xsl:call-template name="zabieg">
            <xsl:with-param name="value" select="zabieg-reoper"/>
            <xsl:with-param name="header" select="'Zabieg  reoperacja'"/>
          </xsl:call-template>
          <xsl:call-template name="leczenie-dod"/>
          <xsl:call-template name="zast-lecz-uwagi"/>
          <xsl:call-template name="centyle"/>
          <xsl:call-template name="podane-leki"/>
          <xsl:call-template name="epikryza"/>
          <xsl:call-template name="leki"/>
          <xsl:call-template name="zalecenia"/>
          <xsl:call-template name="skierowania"/>
          <xsl:call-template name="zwolnienia"/>
          <xsl:call-template name="termin-nast-kons"/>
          <xsl:call-template name="zlecenie-trans"/>
          <xsl:call-template name="rozpoznanie-onkol"/>
          <xsl:call-template name="dokumenty-dodatkowe"/>
          <xsl:call-template name="zabiegi-wykonane"/>
          <xsl:call-template name="sesje-terapii"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:call-template name="stopka"/>
    </body>
  </html>

</xsl:template>

<!--================================================================================================
  szablony do wywietlania wartoci tekstowych
=================================================================================================-->

<xsl:template name="text">

  <xsl:param name="value"/>

  <xsl:variable name="_value" select="string($value)"/>

  <xsl:if test="$_value != ''">
    <pre>
      <xsl:value-of select="$_value"/>
    </pre>
  </xsl:if>

</xsl:template>

<!--=============================================================================================-->

<xsl:template name="text-div">

  <xsl:param name="value"/>
  <xsl:param name="header"/>

  <xsl:variable name="_value" select="string($value)"/>
  <xsl:variable name="_header" select="string($header)"/>

  <xsl:if test="$_value != ''">

    <div>

      <xsl:if test="$_header != ''">
        <span class="header">
          <xsl:value-of select="concat($_header, ': ')"/>
        </span>
      </xsl:if>

      <xsl:call-template name="text">
        <xsl:with-param name="value" select="$_value"/>
      </xsl:call-template>

    </div>

  </xsl:if>

</xsl:template>

<!--=============================================================================================-->

<xsl:template name="text-table">

  <xsl:param name="value"/>

  <table>
    <tr>
      <td>
        <xsl:call-template name="text">
          <xsl:with-param name="value" select="$value"/>
        </xsl:call-template>
      </td>
    </tr>
  </table>

</xsl:template>

<!--=============================================================================================-->

<xsl:template name="text-tr">

  <xsl:param name="header"/>
  <xsl:param name="value"/>
  <xsl:param name="colspan" select="1"/>
  <xsl:param name="header-colspan" select="1"/>
  <xsl:param name="header-align" select="'left'"/>

  <tr>

    <xsl:call-template name="text-td">
      <xsl:with-param name="header" select="$header"/>
      <xsl:with-param name="value" select="$value"/>
      <xsl:with-param name="colspan" select="$colspan"/>
      <xsl:with-param name="header-colspan" select="$header-colspan"/>
      <xsl:with-param name="header-align" select="$header-align"/>
    </xsl:call-template>

  </tr>

</xsl:template>

<!--=============================================================================================-->

<xsl:template name="text-td">

  <xsl:param name="value"/>
  <xsl:param name="colspan" select="1"/>
  <xsl:param name="align" select="'left'"/>

  <td align="{$align}">
    <xsl:if test="$colspan > 1">
      <xsl:attribute name="colspan">
        <xsl:value-of select="$colspan"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:call-template name="text">
      <xsl:with-param name="value" select="$value"/>
    </xsl:call-template>
  </td>

</xsl:template>

<!--================================================================================================
  data wystawienia
=================================================================================================-->

<xsl:template name="data-wyst">

  <div>
    <span id="data-wyst">Data wystawienia&#160;&#160;</span>
    <xsl:value-of select="hospitalizacja/@data-biez"/>
  </div>

</xsl:template>

<!--================================================================================================
  epikryza
=================================================================================================-->

<xsl:template name="epikryza">

  <xsl:if test="hospitalizacja/@epikryza">

    <h2>Epikryza</h2>

    <xsl:call-template name="text-table">
      <xsl:with-param name="value" select="hospitalizacja/@epikryza"/>
    </xsl:call-template>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  leczenie-dod
=================================================================================================-->

<xsl:template name="leczenie-dod">

  <xsl:if test="hospitalizacja/@leczenie-dod">

    <h2>Leczenie</h2>

    <xsl:call-template name="text-table">
      <xsl:with-param name="value" select="hospitalizacja/@leczenie-dod"/>
    </xsl:call-template>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  status normy
=================================================================================================-->

<xsl:template name="status-normy">
  <xsl:param name="odstep" select="' '"/>
  <xsl:if test="@status-normy!=''">
    <xsl:value-of select="$odstep"/>
    <xsl:text>[</xsl:text>
    <xsl:value-of select="@status-normy"/>
    <xsl:text>]</xsl:text>
  </xsl:if>
</xsl:template>

<!--================================================================================================
  hospitalizacja
=================================================================================================-->

<xsl:template name="hospitalizacja">

  <!-- nagwek -->

  <h2>
    <xsl:text>Hospitalizacja</xsl:text>
    <xsl:if test="hospitalizacja/@nr-ksiegi">
      <xsl:value-of select="concat(' nr ', hospitalizacja/@nr-ksiegi)"/>
    </xsl:if>
  </h2>

  <!-- VIII cz kodu resortowego -->

  <div class="header">Specjalno komrki org.</div>

  <xsl:choose>
    <xsl:when test="komorka/@kod-res-8 and komorka/@nazwa-spec">
      <div>
        <xsl:call-template name="text">
          <xsl:with-param name="value" select="komorka/@nazwa-spec"/>
        </xsl:call-template>
        <xsl:text>, </xsl:text>
        <span class="header">kod res. cz. VIII: </span>
        <xsl:call-template name="text">
          <xsl:with-param name="value" select="komorka/@kod-res-8"/>
        </xsl:call-template>
      </div>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="text-div">
        <xsl:with-param name="value" select="komorka/@kod-res-8"/>
        <xsl:with-param name="header" select="'Kod res. cz. VIII'"/>
      </xsl:call-template>
      <xsl:call-template name="text-div">
        <xsl:with-param name="value" select="komorka/@nazwa-spec"/>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>

  <!-- VII cz kodu resortowego -->

  <div>
    <xsl:call-template name="text">
      <xsl:with-param name="value" select="komorka/@nazwa"/>
    </xsl:call-template>
    <xsl:if test="komorka/@kod-res-7">
      <xsl:text>, </xsl:text>
      <span class="header">kod res. cz. VII: </span>
      <xsl:call-template name="text">
        <xsl:with-param name="value" select="komorka/@kod-res-7"/>
      </xsl:call-template>
    </xsl:if>
  </div>

  <!-- V cz kodu resortowego -->

  <xsl:choose>
    <xsl:when test="komorka/@kod-res-5 and komorka/@nazwa-jedn-org">
      <div>
        <xsl:call-template name="text">
          <xsl:with-param name="value" select="komorka/@nazwa-jedn-org"/>
        </xsl:call-template>
        <xsl:text>, </xsl:text>
        <span class="header">kod res. cz. V: </span>
        <xsl:call-template name="text">
          <xsl:with-param name="value" select="komorka/@kod-res-5"/>
        </xsl:call-template>
      </div>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="text-div">
        <xsl:with-param name="value" select="komorka/@kod-res-5"/>
        <xsl:with-param name="header" select="'Kod res. cz. V'"/>
      </xsl:call-template>
      <xsl:call-template name="text-div">
        <xsl:with-param name="value" select="komorka/@nazwa-jedn-org"/>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>

  <!-- data przyjcia i wypisu -->

  <div class="header">Data hospitalizacji</div>

  <div>
	<span class="header">Przyjcie: </span>
	<xsl:call-template name="text">
	  <xsl:with-param name="value" select="hospitalizacja/@data-od"/>
	</xsl:call-template>
	<xsl:text>, </xsl:text>
	<span class="header">Wiek: </span>
	<xsl:call-template name="text">
	  <xsl:with-param name="value" select="hospitalizacja/@data-od-wiek"/>
	</xsl:call-template>
  </div>
  
  <div>
	<span class="header">Wypis: </span>
	<xsl:call-template name="text">
	  <xsl:with-param name="value" select="hospitalizacja/@data-do"/>
	</xsl:call-template>
	<xsl:text>, </xsl:text>
	<span class="header">Wiek: </span>
	<xsl:call-template name="text">
	  <xsl:with-param name="value" select="hospitalizacja/@data-do-wiek"/>
	</xsl:call-template>
  </div>

  <!-- tryb wypisu -->

  <xsl:if test="hospitalizacja/@tryb-wypisu">
    <div class="header">Tryb wypisu</div>
    <xsl:call-template name="text-div">
      <xsl:with-param name="value" select="hospitalizacja/@tryb-wypisu"/>
    </xsl:call-template>
  </xsl:if>

</xsl:template>

<!--================================================================================================
  wyniki konsultacji
=================================================================================================-->

<xsl:template name="konsultacje">

  <xsl:if test="konsultacje">

    <h2>Konsultacje</h2>

    <table>

      <col width="80"/>

      <tr>
        <th>Data wyk.</th>
        <th>Poradnia</th>
        <th>Opis</th>
      </tr>

      <xsl:for-each select="konsultacje/*">

        <tr>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@data"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@nazwa"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@opis"/>
          </xsl:call-template>

        </tr>

      </xsl:for-each>

    </table>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  przepisane leki
=================================================================================================-->

<xsl:template name="leki">

  <xsl:if test="leki">

    <xsl:variable name="_czy_pin" select="leki/*[@pin]"/>

    <h2>Recepty</h2>

    <table>

      <col width="40%"/>
      <col/>
      <col/>
      <xsl:if test="$_czy_pin">
        <col width="80"/>
      </xsl:if>

      <tr>
        <th>Nazwa lub skad leku</th>
        <th>Sposb podania</th>
        <th>Dawkowanie</th>
        <xsl:if test="$_czy_pin">
          <th>PIN</th>
        </xsl:if>
      </tr>

      <xsl:for-each select="leki/*">

        <tr>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value">
              <xsl:choose>
                <xsl:when test="name() = 'lek-recepturowy'">
                  <xsl:value-of select="@sklad"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="@nazwa"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:with-param>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@podanie"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@dawkowanie"/>
          </xsl:call-template>

          <xsl:if test="$_czy_pin">
            <xsl:call-template name="text-td">
              <xsl:with-param name="value" select="@pin"/>
            </xsl:call-template>
          </xsl:if>

        </tr>

      </xsl:for-each>

    </table>

  </xsl:if>

</xsl:template>

<!--================================================================================================
 podane leki
=================================================================================================-->

<xsl:template name="podane-leki">

  <xsl:if test="podane-leki/node()">

    <h2>Podane leki</h2>

    <table>

      <col width="100%"/>

      <xsl:for-each select="podane-leki/lek">

        <tr>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@nazwa"/>
          </xsl:call-template>

        </tr>

      </xsl:for-each>

    </table>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  nagwek
=================================================================================================-->

<xsl:template name="naglowek">

  <h1 id="naglowek-strony">Karta informacyjna z leczenia szpitalnego</h1>

  <table>

    <tr>
      <td colspan="2">
        <xsl:call-template name="data-wyst"/>
      </td>
    </tr>

    <tr>
      <td>
        <xsl:call-template name="pacjent"/>
      </td>
      <td>
        <xsl:call-template name="wystawca-dokumentu"/>
      </td>
    </tr>

    <tr>
      <td>
        <xsl:call-template name="hospitalizacja"/>
      </td>
      <td>
        <xsl:call-template name="swiadczeniodawca"/>
      </td>
    </tr>

  </table>

</xsl:template>

<!--================================================================================================
  pacjent
=================================================================================================-->

<xsl:template name="pacjent">

  <!-- nagwek -->

  <h2>Pacjent</h2>

  <!-- nazwisko i imi -->

  <xsl:call-template name="text-div">
    <xsl:with-param name="value" select="concat(pacjent/@nazwisko, ' ', pacjent/@imie)"/>
  </xsl:call-template>

  <!-- identyfikator pacjenta -->

  <xsl:call-template name="text-div">
    <xsl:with-param name="value">
      <xsl:choose>
        <xsl:when test="pacjent/@pesel != '00000000000'">
          <xsl:value-of select="pacjent/@pesel"/>
        </xsl:when>
        <xsl:when test="pacjent/@pac-dok-tozs">
          <xsl:value-of select="pacjent/@pac-dok-tozs"/>
        </xsl:when>
        <xsl:when test="pacjent/@czy-noworodek and pacjent/@matka-pesel != '00000000000'">
          <xsl:value-of select="pacjent/@matka-pesel"/>
        </xsl:when>
        <xsl:when test="pacjent/@czy-noworodek and pacjent/@matka-nr-dok-tozs">
          <xsl:value-of select="pacjent/@matka-nr-dok-tozs"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="pacjent/@pesel"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
    <xsl:with-param name="header">
      <xsl:choose>
        <xsl:when test="pacjent/@pesel != '00000000000'">
          <xsl:value-of select="'PESEL'"/>
        </xsl:when>
        <xsl:when test="pacjent/@pac-dok-tozs">
          <xsl:value-of select="'Dok. tos.'"/>
        </xsl:when>
        <xsl:when test="pacjent/@czy-noworodek and pacjent/@matka-pesel != '00000000000'">
          <xsl:value-of select="'PESEL matki'"/>
        </xsl:when>
        <xsl:when test="pacjent/@czy-noworodek and pacjent/@matka-nr-dok-tozs">
          <xsl:value-of select="'Dok. tos. matki'"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="'PESEL'"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  </xsl:call-template>

  <!-- data urodzenia -->

  <xsl:call-template name="text-div">
    <xsl:with-param name="value" select="pacjent/@data-ur"/>
    <xsl:with-param name="header" select="'Data ur.'"/>
  </xsl:call-template>

  <!-- wiek i pe -->

  <div>
    <span class="header">Pe: </span>
    <xsl:value-of select="pacjent/@plec"/>
  </div>

  <!-- adres -->

  <xsl:call-template name="text-div">
    <xsl:with-param name="value" select="pacjent/@adres"/>
    <xsl:with-param name="header" select="'Adres'"/>
  </xsl:call-template>

</xsl:template>

<!--================================================================================================
  wystawca-dokumentu
=================================================================================================-->

<xsl:template name="wystawca-dokumentu">

  <!-- nagwek -->

  <h2>Wystawca dokumentu</h2>

  <!-- personel -->

  <xsl:call-template name="personel">
    <xsl:with-param name="value" select="personel"/>
  </xsl:call-template>

</xsl:template>

<!--================================================================================================
  oceny icf
=================================================================================================-->

<xsl:template name="oceny-icf">

  <xsl:if test="oceny-icf">

    <h2>Ocena ICF</h2>

    <table>

      <col width="60"/>

      <tr>
        <th>Kod</th>
        <th>Nazwa</th>
        <th>K1</th>
        <th>K2</th>
        <th>K3</th>
      </tr>

      <xsl:for-each select="oceny-icf/*">

        <tr>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@kod"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@nazwa"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value">
              <xsl:if test="@konc-kwalif-1-kod">
                <xsl:value-of select="concat(@konc-kwalif-1-kod, '  ', @konc-kwalif-1-nazwa)"/>
              </xsl:if>
            </xsl:with-param>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value">
              <xsl:if test="@konc-kwalif-2-kod">
                <xsl:value-of select="concat(@konc-kwalif-2-kod, '  ', @konc-kwalif-2-nazwa)"/>
              </xsl:if>
            </xsl:with-param>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value">
              <xsl:if test="@konc-kwalif-3-kod">
                <xsl:value-of select="concat(@konc-kwalif-3-kod, '  ', @konc-kwalif-3-nazwa)"/>
              </xsl:if>
            </xsl:with-param>
          </xsl:call-template>

        </tr>

      </xsl:for-each>

    </table>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  personel
=================================================================================================-->

<xsl:template name="personel">

  <xsl:param name="value"/>
  <xsl:param name="czydlatd"/>

  <xsl:variable name="enter">
    <xsl:if test="$czydlatd">
      <xsl:text>&#10;</xsl:text>
    </xsl:if>
  </xsl:variable>
  <xsl:choose>

    <xsl:when test="$value/@podpis">

      <!-- podpis -->

      <xsl:call-template name="text-div">
        <xsl:with-param name="value" select="$value/@podpis"/>
      </xsl:call-template>

    </xsl:when>

    <xsl:otherwise>

    <!-- specjalnoci -->

    <xsl:call-template name="text-div">
      <xsl:with-param name="value">
        <xsl:value-of select="$value/@specjalnosci"/>
        <xsl:value-of select="$enter"/>
      </xsl:with-param>
    </xsl:call-template>

    <!-- nazwisko i imi -->

    <xsl:call-template name="text-div">
      <xsl:with-param name="value" select="concat($value/@nazwisko, ' ', $value/@imie)"/>
    </xsl:call-template>

    <!-- nr prawa -->

    <xsl:call-template name="text-div">
      <xsl:with-param name="value" select="$value/@nr-prawa"/>
      <xsl:with-param name="header">
        <xsl:value-of select="$enter"/>
        <xsl:value-of select="'NPWZ'"/>
      </xsl:with-param>
    </xsl:call-template>

    </xsl:otherwise>

  </xsl:choose>

</xsl:template>

<!--================================================================================================
  rozpoznania z wypisu
=================================================================================================-->

<xsl:template name="rozpoznania-wyp">

  <xsl:if test="rozpoznania or hospitalizacja/@rozpoznanie-pac">

    <xsl:variable name="czy-opis" select="rozpoznania/rozpoznanie/@opis"/>

    <div id="rozp-icd10">

      <h2>Rozpoznania</h2>

      <table>

        <col/>
        <xsl:if test="$czy-opis">
          <col/>
        </xsl:if>
        <col width="100"/>

        <!-- rozpoznania wg ICD-10 -->

        <xsl:if test="rozpoznania">

          <tr>
            <th>Nazwa</th>
            <xsl:if test="$czy-opis">
              <th>Opis</th>
            </xsl:if>
            <th>Kod</th>
          </tr>

          <xsl:for-each select="rozpoznania/rozpoznanie">

            <tr>

              <xsl:call-template name="text-td">
                <xsl:with-param name="value" select="@nazwa"/>
              </xsl:call-template>

              <xsl:if test="$czy-opis">
                <xsl:call-template name="text-td">
                  <xsl:with-param name="value" select="@opis"/>
                </xsl:call-template>
              </xsl:if>

              <xsl:call-template name="text-td">
                <xsl:with-param name="value" select="@kod"/>
              </xsl:call-template>

            </tr>

          </xsl:for-each>

        </xsl:if>

        <!-- rozpoznanie dla pacjenta -->

        <xsl:if test="hospitalizacja/@rozpoznanie-pac">

          <tr>
            <th colspan="2">Rozpoznanie na podstawie art. 9 ust. 4 ustawy o prawach pacjenta i Rzeczniku Praw Pacjenta</th>
          </tr>

          <tr>
            <xsl:call-template name="text-td">
              <xsl:with-param name="value" select="hospitalizacja/@rozpoznanie-pac"/>
              <xsl:with-param name="colspan" select="2"/>
            </xsl:call-template>
          </tr>

        </xsl:if>

      </table>

    </div>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  przyczyny zgonu
=================================================================================================-->

<xsl:template name="rozpoznania-zgon">

  <h2>Przyczyny zgonu</h2>

  <xsl:variable name="czy-opis" select="zgon/przyczyna-wyj/@opis or zgon/przyczyna-wtor/@opis or zgon/przyczyna-bezp/@opis"/>

  <table>

    <col width="90"/>
    <col/>
    <xsl:if test="$czy-opis">
      <col/>
    </xsl:if>
    <col width="100"/>

    <tr>
      <th>Przyczyna</th>
      <th>Rozpoznanie choroby</th>
      <xsl:if test="$czy-opis">
        <th>Opis</th>
      </xsl:if>
      <th>Kod</th>
    </tr>

    <!-- przyczyna wyjciowa -->

    <tr>

      <td>Wyjciowa</td>

      <xsl:call-template name="text-td">
        <xsl:with-param name="value" select="zgon/przyczyna-wyj/@nazwa"/>
      </xsl:call-template>

      <xsl:if test="$czy-opis">
        <xsl:call-template name="text-td">
          <xsl:with-param name="value" select="zgon/przyczyna-wyj/@opis"/>
        </xsl:call-template>
      </xsl:if>

      <xsl:call-template name="text-td">
        <xsl:with-param name="value" select="zgon/przyczyna-wyj/@kod"/>
      </xsl:call-template>

    </tr>

    <!-- przyczyna wtna -->

    <tr>

      <td>Wtrna</td>

      <xsl:call-template name="text-td">
        <xsl:with-param name="value" select="zgon/przyczyna-wtor/@nazwa"/>
      </xsl:call-template>

      <xsl:if test="$czy-opis">
        <xsl:call-template name="text-td">
          <xsl:with-param name="value" select="zgon/przyczyna-wtor/@opis"/>
        </xsl:call-template>
      </xsl:if>

      <xsl:call-template name="text-td">
        <xsl:with-param name="value" select="zgon/przyczyna-wtor/@kod"/>
      </xsl:call-template>

    </tr>

    <!-- przyczyna bezporednia -->

    <tr>

      <td>Bezporednia</td>

      <xsl:call-template name="text-td">
        <xsl:with-param name="value" select="zgon/przyczyna-bezp/@nazwa"/>
      </xsl:call-template>

      <xsl:if test="$czy-opis">
        <xsl:call-template name="text-td">
          <xsl:with-param name="value" select="zgon/przyczyna-bezp/@opis"/>
        </xsl:call-template>
      </xsl:if>

      <xsl:call-template name="text-td">
        <xsl:with-param name="value" select="zgon/przyczyna-bezp/@kod"/>
      </xsl:call-template>

    </tr>

  </table>

</xsl:template>

<!--================================================================================================
  realizujacy
=================================================================================================-->

<xsl:template name="realizujacy">

  <xsl:param name="personel"/>
  <xsl:param name="specjalnosci"/>
  <xsl:param name="npwz"/>

  <xsl:value-of select="$personel"/>
  <xsl:if test="string($specjalnosci)">
    <xsl:text>; </xsl:text>
    <xsl:value-of select="$specjalnosci"/>
  </xsl:if>
  <xsl:if test="string($npwz)">
    <xsl:text>; NPWZ: </xsl:text>
    <xsl:value-of select="$npwz"/>
  </xsl:if>

</xsl:template>

<!--================================================================================================
  rozpoznanie dla pacjenta
=================================================================================================-->

<xsl:template name="rozpoznanie-pac">

  <xsl:if test="hospitalizacja/@rozpoznanie-pac">

    <div id="rozp-pac" class="hidden">

      <h2>Rozpoznanie</h2>

      <xsl:call-template name="text-table">
        <xsl:with-param name="value" select="hospitalizacja/@rozpoznanie-pac"/>
      </xsl:call-template>

    </div>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  sekcja zwok
=================================================================================================-->

<xsl:template name="sekcja">

  <h2>Sekcja zwok</h2>

  <table>

    <col width="90"/>

    <tr>
      <th>Wykonano</th>
      <th>Uzasadnienie decyzji</th>
    </tr>

    <tr>

      <xsl:call-template name="text-td">
        <xsl:with-param name="value">
          <xsl:choose>
            <xsl:when test="zgon/@czy-sekcja">TAK</xsl:when>
            <xsl:otherwise>NIE</xsl:otherwise>
          </xsl:choose>
        </xsl:with-param>
      </xsl:call-template>

      <xsl:call-template name="text-td">
        <xsl:with-param name="value" select="zgon/@uzasadnienie-sekcji"/>
      </xsl:call-template>

    </tr>

  </table>

</xsl:template>

<!--====================================================================================================================
  sesje terapii
=====================================================================================================================-->

<xsl:template name="sesje-terapii">

  <xsl:if test="sesje-terapii/node()">

    <h2 class="wypis">Sesje terapii</h2>

    <table>

      <col width="80%"/>
      <col width="20%"/>

      <tr>
        <th>Rodzaj</th>
        <th>Liczba sesji</th>
      </tr>

      <xsl:for-each select="sesje-terapii/sesja">

        <tr>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@rodzaj"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@liczba"/>
            <xsl:with-param name="align" select="'right'"/>
          </xsl:call-template>

        </tr>

      </xsl:for-each>

    </table>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  wystawione skierowania
=================================================================================================-->

<xsl:template name="skierowania">

  <xsl:if test="skierowania">

    <xsl:variable name="_czy_pin" select="skierowania/*[@pin]"/>

    <h2>Wystawione skierowania</h2>

    <table>

      <col width="190"/>
      <col/>
      <xsl:if test="$_czy_pin">
        <col width="80"/>
      </xsl:if>

      <tr>
        <th>Rodzaj</th>
        <th>Dane</th>
        <xsl:if test="$_czy_pin">
          <th>PIN</th>
        </xsl:if>
      </tr>

      <xsl:for-each select="skierowania/*">
        <tr>
          <xsl:choose>
            <xsl:when test="name() = 'skierowanie-bad-diag'">
              <xsl:call-template name="skierowanie-bad-diag"/>
            </xsl:when>
            <xsl:when test="name() = 'skierowanie-bad-lab'">
              <xsl:call-template name="skierowanie-bad-lab"/>
            </xsl:when>
            <xsl:when test="name() = 'skierowanie-druk-krus-n14'">
              <xsl:call-template name="skierowanie-druk-krus-n14"/>
            </xsl:when>
            <xsl:when test="name() = 'skierowanie-druk-zus-n9'">
              <xsl:call-template name="skierowanie-druk-zus-n9"/>
            </xsl:when>
            <xsl:when test="name() = 'skierowanie-histopat'">
              <xsl:call-template name="skierowanie-histopat"/>
            </xsl:when>
            <xsl:when test="name() = 'skierowanie-opieka-dlug'">
              <xsl:call-template name="skierowanie-opieka-dlug"/>
            </xsl:when>
            <xsl:when test="name() = 'skierowanie-rehab'">
              <xsl:call-template name="skierowanie-rehab"/>
            </xsl:when>
            <xsl:when test="name() = 'skierowanie-sanatorium'">
              <xsl:call-template name="skierowanie-sanatorium"/>
            </xsl:when>
            <xsl:when test="name() = 'skierowanie-spec'">
              <xsl:call-template name="skierowanie-spec"/>
            </xsl:when>
            <xsl:when test="name() = 'skierowanie-szpit'">
              <xsl:call-template name="skierowanie-szpit"/>
            </xsl:when>
            <xsl:when test="name() = 'skierowanie-szpit-psych'">
              <xsl:call-template name="skierowanie-szpit-psych"/>
            </xsl:when>
            <xsl:when test="name() = 'skierowanie-trans'">
              <xsl:call-template name="skierowanie-trans"/>
            </xsl:when>
            <xsl:when test="name() = 'skierowanie-zaopmed'">
              <xsl:call-template name="skierowanie-zaopmed"/>
            </xsl:when>
            <xsl:when test="name() = 'skierowanie-zaswlek'">
              <xsl:call-template name="skierowanie-zaswlek"/>
            </xsl:when>
            <xsl:when test="name() = 'skierowanie-zaswniepelnospr'">
              <xsl:call-template name="skierowanie-zaswniepelnospr"/>
            </xsl:when>
          </xsl:choose>

          <xsl:if test="$_czy_pin">
            <xsl:call-template name="text-td">
              <xsl:with-param name="value" select="@pin"/>
            </xsl:call-template>
          </xsl:if>

        </tr>
      </xsl:for-each>

    </table>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  skierowanie na badanie diagnostyczne
=================================================================================================-->

<xsl:template name="skierowanie-bad-diag">

  <td>Badanie diagnostyczne</td>

  <xsl:call-template name="text-td">
    <xsl:with-param name="value" select="@badanie"/>
  </xsl:call-template>

</xsl:template>

<!--================================================================================================
  skierowanie na badania laboratoryjne
=================================================================================================-->

<xsl:template name="skierowanie-bad-lab">

  <td>Badania laboratoryjne</td>

  <td>
    <xsl:for-each select="badanie">
      <xsl:call-template name="text-div">
        <xsl:with-param name="value" select="@nazwa"/>
      </xsl:call-template>
    </xsl:for-each>
  </td>

</xsl:template>

<!--====================================================================================================================
  skierowanie na badanie histopatologiczne
=====================================================================================================================-->

<xsl:template name="skierowanie-histopat">

  <td>Badanie histopatologiczne</td>

  <xsl:call-template name="text-td">
    <xsl:with-param name="value" select="@material"/>
  </xsl:call-template>

</xsl:template>

<!--====================================================================================================================
  skierowanie druk N-14 (stan zdrowia)
=====================================================================================================================-->

<xsl:template name="skierowanie-druk-krus-n14">

  <td>Druk N-14 (stan zdrowia)</td>
  <td></td>

</xsl:template>

<!--====================================================================================================================
  skierowanie druk OL-9 (stan zdrowia)
=====================================================================================================================-->

<xsl:template name="skierowanie-druk-zus-n9">

  <td>Druk OL-9 (stan zdrowia)</td>
  <td></td>

</xsl:template>

<!--================================================================================================
  skierowanie na opiek dugoterminow
=================================================================================================-->

<xsl:template name="skierowanie-opieka-dlug">

  <td>Opieka dugoterminowa domowa</td>
  <td></td>

</xsl:template>

<!--================================================================================================
  skierowanie na zabiegi rehabilitacyjne
=================================================================================================-->

<xsl:template name="skierowanie-rehab">

  <td>Rehabilitacja</td>

  <td>
    <xsl:for-each select="zabieg">
      <xsl:call-template name="text-div">
        <xsl:with-param name="value">
          <xsl:value-of select="@nazwa"/>
          <xsl:choose>
            <xsl:when test="@liczba-powt-lub-czas">
              <xsl:value-of select="concat(', ', @liczba-powt-lub-czas)"/>
            </xsl:when>
            <xsl:when test="@liczba-powt and @czas-trwania">
              <xsl:value-of select="concat(', ', @liczba-powt, ' x ', @czas-trwania, ' min')"/>
            </xsl:when>
            <xsl:when test="@liczba-powt">
              <xsl:value-of select="concat(', ', @liczba-powt, 'x')"/>
            </xsl:when>
            <xsl:when test="@czas-trwania">
              <xsl:value-of select="concat(', ', @czas-trwania, ' min')"/>
            </xsl:when>
          </xsl:choose>
          <xsl:if test="@parametry">
            <xsl:value-of select="concat(', ', @parametry)"/>
          </xsl:if>
          <xsl:if test="@okolica-ciala">
            <xsl:value-of select="concat(', ', @okolica-ciala)"/>
          </xsl:if>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:for-each>
  </td>

</xsl:template>

<!--====================================================================================================================
  skierowanie do sanatorium
=====================================================================================================================-->

<xsl:template name="skierowanie-sanatorium">

  <td>Sanatorium</td>
  <td></td>

</xsl:template>

<!--================================================================================================
  skierowanie do specjalisty
=================================================================================================-->

<xsl:template name="skierowanie-spec">

  <td>Konsultacja u specjalisty</td>

  <xsl:call-template name="text-td">
    <xsl:with-param name="value" select="@poradnia"/>
  </xsl:call-template>

</xsl:template>

<!--================================================================================================
  skierowanie do szpitala
=================================================================================================-->

<xsl:template name="skierowanie-szpit">

  <td>Do szpitala</td>

  <xsl:call-template name="text-td">
    <xsl:with-param name="value" select="@oddzial"/>
  </xsl:call-template>

</xsl:template>

<!--================================================================================================
  skierowanie do szpitala psychiatrycznego
=================================================================================================-->

<xsl:template name="skierowanie-szpit-psych">

  <td>Do szpitala psychiatrycznego</td>
  <td></td>

</xsl:template>

<!--================================================================================================
  zlecenie na transport
=================================================================================================-->

<xsl:template name="skierowanie-trans">

  <td>Transport sanitarny</td>

  <xsl:call-template name="text-td">
    <xsl:with-param name="value" select="@cel-przewozu"/>
  </xsl:call-template>

</xsl:template>

<!--================================================================================================
  zlecenie na zaopatrzenie w wyroby medyczne
=================================================================================================-->

<xsl:template name="skierowanie-zaopmed">

  <td>Zaopatrzenie w wyroby medyczne</td>

  <xsl:call-template name="text-td">
    <xsl:with-param name="value" select="@wyrob"/>
  </xsl:call-template>

</xsl:template>

<!--====================================================================================================================
  skierowanie zawiadczenie dla Zespou ds. OoN
=====================================================================================================================-->

<xsl:template name="skierowanie-zaswniepelnospr">

  <td>Zawiadczenie dla Zespou ds. OoN</td>
  <td></td>

</xsl:template>

<!--====================================================================================================================
  skierowanie zawiadczenie lekarskie
=====================================================================================================================-->

<xsl:template name="skierowanie-zaswlek">

  <td>Zawiadczenie lekarskie</td>

  <xsl:call-template name="text-td">
    <xsl:with-param name="value" select="@cel-wydania"/>
  </xsl:call-template>

</xsl:template>

<!--================================================================================================
  stopka
=================================================================================================-->

<xsl:template name="stopka">

  <table id="stopka">
    <tr>
      <td><br/></td>
    </tr>
    <tr>
      <xsl:call-template name="text-td">
        <xsl:with-param name="value">
          <xsl:call-template name="personel">
            <xsl:with-param name="value" select="lek-wypisujacy"/>
            <xsl:with-param name="czydlatd" select="'1'"/>
          </xsl:call-template>
        </xsl:with-param>
        <xsl:with-param name="align" select="'center'"/>
      </xsl:call-template>
      <xsl:call-template name="text-td">
        <xsl:with-param name="value">
          <xsl:call-template name="personel">
            <xsl:with-param name="value" select="lek-generujacy"/>
            <xsl:with-param name="czydlatd" select="'1'"/>
          </xsl:call-template>
        </xsl:with-param>
        <xsl:with-param name="align" select="'center'"/>
      </xsl:call-template>
    </tr>
    <tr>
      <th>Data i podpis wystawiajcego</th>
      <th>Wydrukowa/(a)</th>
    </tr>
    <tr>
      <xsl:call-template name="text-td">
        <xsl:with-param name="value">
          <xsl:call-template name="personel">
            <xsl:with-param name="value" select="lek-podpisujacy-wypis"/>
            <xsl:with-param name="czydlatd" select="'1'"/>
          </xsl:call-template>
        </xsl:with-param>
        <xsl:with-param name="align" select="'center'"/>
      </xsl:call-template>
      <td><br/><br/><br/></td>
    </tr>
    <tr>
      <th>Ordynator/Kierownik oddziau/Upowaniony</th>
      <th></th>
    </tr>
  </table>

</xsl:template>

<!--================================================================================================
  wiadczeniodawca
=================================================================================================-->

<xsl:template name="swiadczeniodawca">

  <xsl:variable name="czy-adres-kom" select="komorka/@adres or komorka/@email or komorka/@fax or komorka/@telefon"/>

  <!-- nagwek -->

  <h2>Miejsce wystawienia</h2>

  <!-- nazwa podmiotu -->

  <xsl:call-template name="text-div">
    <xsl:with-param name="value" select="swiadczeniodawca/@nazwa-podm"/>
  </xsl:call-template>

  <!-- nazwa przedsibiorstwa -->

  <xsl:call-template name="text-div">
    <xsl:with-param name="value" select="swiadczeniodawca/@nazwa"/>
  </xsl:call-template>

  <!-- I cz kodu resortowego -->

  <xsl:call-template name="text-div">
    <xsl:with-param name="value" select="swiadczeniodawca/@kod-res-1"/>
    <xsl:with-param name="header" select="'Kod res. I'"/>
  </xsl:call-template>

  <!-- REGON -->

  <xsl:call-template name="text-div">
    <xsl:with-param name="value" select="swiadczeniodawca/@regon"/>
    <xsl:with-param name="header" select="'REGON'"/>
  </xsl:call-template>

  <!-- adres -->

  <div class="header">Adres</div>

  <xsl:call-template name="text-div">
    <xsl:with-param name="value">
      <xsl:choose>
        <xsl:when test="$czy-adres-kom">
          <xsl:value-of select="komorka/@adres"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="swiadczeniodawca/@adres"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  </xsl:call-template>

  <!-- telefon, fax i email -->

  <div class="header">Dane kontaktowe</div>

  <xsl:call-template name="text-div">
    <xsl:with-param name="value">
      <xsl:choose>
        <xsl:when test="$czy-adres-kom">
          <xsl:value-of select="komorka/@telefon"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="swiadczeniodawca/@telefon"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
    <xsl:with-param name="header" select="'tel.'"/>
  </xsl:call-template>

  <xsl:call-template name="text-div">
    <xsl:with-param name="value">
      <xsl:choose>
        <xsl:when test="$czy-adres-kom">
          <xsl:value-of select="komorka/@fax"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="swiadczeniodawca/@fax"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
    <xsl:with-param name="header" select="'fax'"/>
  </xsl:call-template>

  <xsl:call-template name="text-div">
    <xsl:with-param name="value">
      <xsl:choose>
        <xsl:when test="$czy-adres-kom">
          <xsl:value-of select="komorka/@email"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="swiadczeniodawca/@email"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
    <xsl:with-param name="header" select="'e-mail'"/>
  </xsl:call-template>

</xsl:template>

<!--================================================================================================
  termin nastpnej konsultacji
=================================================================================================-->

<xsl:template name="termin-nast-kons">

  <xsl:if test="hospitalizacja/@termin-nast-kons">

    <h2>Termin nastpnej konsultacji</h2>

    <xsl:call-template name="text-table">
      <xsl:with-param name="value" select="hospitalizacja/@termin-nast-kons"/>
    </xsl:call-template>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  zalecenia
=================================================================================================-->

<xsl:template name="zalecenia">

  <xsl:if test="hospitalizacja/@zalecenia">

    <h2>Zalecenia</h2>

    <xsl:call-template name="text-table">
      <xsl:with-param name="value" select="hospitalizacja/@zalecenia"/>
    </xsl:call-template>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  wyniki bada diagnostycznych
=================================================================================================-->

<xsl:template name="wyniki-bad-diag">

  <xsl:if test="wyniki-bad-diag">

    <h2>Wyniki bada diagnostycznych</h2>

    <table>

      <col width="80"/>

      <tr>
        <th>Data wyk.</th>
        <th>Nazwa badania</th>
        <th>Opis</th>
      </tr>

      <xsl:for-each select="wyniki-bad-diag/*">

        <tr>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@data"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@nazwa"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@opis"/>
          </xsl:call-template>

        </tr>

      </xsl:for-each>

    </table>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  wyniki bada laboratoryjnych
=================================================================================================-->

<xsl:template name="wyniki-bad-lab">

  <xsl:if test="wyniki-bad-lab">

    <h2>Wyniki bada laboratoryjnych</h2>

    <table>

      <col width="80"/>

      <tr>
        <th>Data wyk.</th>
        <th>Nazwa badania</th>
        <th>Wynik</th>
        <th>Norma</th>
      </tr>

      <xsl:for-each select="wyniki-bad-lab/*">

        <xsl:variable name="czy-opis" select="@opis != ''"/>
        <xsl:variable name="czy-norma" select="@min-wart != '' or @max-wart != '' or @status-normy != ''"/>

        <tr>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@data"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@nazwa"/>
            <xsl:with-param name="colspan">
              <xsl:choose>
                <xsl:when test="$czy-opis">
                  1
                </xsl:when>
                <xsl:otherwise>
                  3
                </xsl:otherwise>
              </xsl:choose>
            </xsl:with-param>
          </xsl:call-template>

          <xsl:if test="$czy-opis">

            <xsl:call-template name="text-td">
              <xsl:with-param name="value" select="@opis"/>
              <xsl:with-param name="colspan">
                <xsl:choose>
                  <xsl:when test="$czy-norma">
                    1
                  </xsl:when>
                  <xsl:otherwise>
                    2
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
            </xsl:call-template>

            <xsl:if test="$czy-norma">

              <xsl:call-template name="text-td">
                <xsl:with-param name="value">
                  <xsl:choose>
                    <xsl:when test="@min-wart != '' and @max-wart != ''">
                      <xsl:value-of select="@min-wart"/>
                      <xsl:text>  </xsl:text>
                      <xsl:value-of select="@max-wart"/>
                      <xsl:call-template name="status-normy">
                        <xsl:with-param name="value" select="@status-normy"/>
                      </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="@min-wart != ''">
                      <xsl:text>Min: </xsl:text>
                      <xsl:value-of select="@min-wart"/>
                      <xsl:call-template name="status-normy">
                        <xsl:with-param name="value" select="@status-normy"/>
                      </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="@max-wart != ''">
                      <xsl:text>Max: </xsl:text>
                      <xsl:value-of select="@max-wart"/>
                      <xsl:call-template name="status-normy">
                        <xsl:with-param name="value" select="@status-normy"/>
                      </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:call-template name="status-normy">
                        <xsl:with-param name="value" select="@status-normy"/>
                        <xsl:with-param name="odstep" select="''"/>
                      </xsl:call-template>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:with-param>
              </xsl:call-template>

            </xsl:if>

          </xsl:if>

        </tr>

      </xsl:for-each>

    </table>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  zabieg
=================================================================================================-->

<xsl:template name="zabieg">

  <xsl:param name="value"/>
  <xsl:param name="header"/>

  <xsl:if test="$value/node() or (count($value/@*) > 0)">

    <div class="section" style="border-bottom: solid 1px black;">
      <xsl:value-of select="$header"/>
    </div>

    <xsl:if test="$value/@opis">

      <table>

        <col/>
        <col/>

        <tr id="opis">
          <th colspan="6">Opis</th>
        </tr>

        <tr id="opis-tresc">
          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="$value/@opis"/>
            <xsl:with-param name="colspan" select="6"/>
          </xsl:call-template>
        </tr>

      </table>

    </xsl:if>

    <!-- dane wykonanych zabiegw -->

    <xsl:choose>
      <xsl:when test="$header = 'Zabieg'">
        <xsl:call-template name="zabieg-procedury">
          <xsl:with-param name="value" select="zabieg-procedury"/>
          <xsl:with-param name="header" select="'Wykonane zabiegi'"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="$header = 'Zabieg  reoperacja'">
        <xsl:call-template name="zabieg-procedury">
          <xsl:with-param name="value" select="zabieg-reoper-procedury"/>
          <xsl:with-param name="header" select="'Wykonane zabiegi'"/>
        </xsl:call-template>
      </xsl:when>
    </xsl:choose>

    <!-- dane personelu z zabiegu -->

    <xsl:if test="$value/osoby-pers">

      <div class="subsection">
        Personel zabiegowy
      </div>

      <table>

        <col/>
        <col/>

        <!-- personel -->

        <tr>
          <th>Rola</th>
          <th>Personel</th>
        </tr>

        <xsl:for-each select="$value/osoby-pers/personel">

          <tr>
            <xsl:call-template name="text-td">
              <xsl:with-param name="value" select="@rola"/>
            </xsl:call-template>
            <xsl:call-template name="text-td">
              <xsl:with-param name="value">
                <xsl:call-template name="realizujacy">
                  <xsl:with-param name="personel" select="@pers-nii"/>
                  <xsl:with-param name="specjalnosci" select="@pers-spec"/>
                  <xsl:with-param name="npwz" select="@pers-npwz"/>
                </xsl:call-template>
              </xsl:with-param>
            </xsl:call-template>
          </tr>

        </xsl:for-each>

      </table>

    </xsl:if>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  zabieg-procedury
=================================================================================================-->

<xsl:template name="zabieg-procedury">

  <xsl:param name="value"/>
  <xsl:param name="header"/>

  <xsl:if test="$value">

    <div class="subsection">
      <xsl:value-of select="$header"/>
    </div>

    <table>

      <col width="73"/>
      <col/>
      <col width="54"/>
      <col width="80"/>
      <col width="80"/>
      <col width="120"/>

      <tr>
        <th>Data wyk.</th>
        <th>Nazwa</th>
        <th>Kod</th>
        <th>Krotno</th>
        <th>Strona ciaa</th>
        <th>Okolica ciaa</th>
      </tr>

      <xsl:for-each select="$value/procedura">

        <tr>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@data"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@nazwa"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@kod"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@krotnosc"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="strona-ciala/@nazwa"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="okolica-ciala/@nazwa"/>
          </xsl:call-template>

        </tr>

      </xsl:for-each>

    </table>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  zlecenie transportu
=================================================================================================-->

<xsl:template name="zlecenie-trans">

  <xsl:variable name="value" select="hospitalizacja/@zlecenie-trans"/>

  <xsl:choose>
    <xsl:when test="$value = '1'">
      <h2>Wydano zlecenie na transport sanitarny</h2>
    </xsl:when>
    <xsl:when test="$value = '2'">
      <h2>Wydano zlecenie na transport sanitarny z art. 30 ust. 1 i 2 ustawy z dnia 15 kwietnia 2011 r. o dziaalnoci leczniczej</h2>
    </xsl:when>
  </xsl:choose>

</xsl:template>

<!--================================================================================================
  wystawione zwolnienia
=================================================================================================-->

<xsl:template name="zwolnienia">

  <xsl:if test="zwolnienia">

    <h2>Wystawione zwolnienia ZUS ZLA</h2>

    <table>

      <tr>
        <th>Niezdolno do pracy od</th>
        <th>Niezdolno do pracy do</th>
        <xsl:choose>
          <xsl:when test="value/@wersja-form = 4">
            <th>Pobyt w szpitalu od</th>
            <th>Pobyt w szpitalu do</th>
          </xsl:when>
          <xsl:otherwise>
            <th>Liczba dni w szpitalu</th>
          </xsl:otherwise>
        </xsl:choose>
        <th>Wskazania lekarskie</th>
      </tr>

      <xsl:for-each select="zwolnienia/zwolnienie">

        <tr>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@data-od"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@data-do"/>
          </xsl:call-template>

          <xsl:choose>
            <xsl:when test="value/@wersja-form = 4">
              <xsl:call-template name="text-td">
                <xsl:with-param name="value" select="@data-szpit-od"/>
              </xsl:call-template>
              <xsl:call-template name="text-td">
                <xsl:with-param name="value" select="@data-szpit-do"/>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="text-td">
                <xsl:with-param name="value" select="@liczba-dni-szpit"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@wskazania"/>
          </xsl:call-template>

        </tr>

      </xsl:for-each>

    </table>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  rozpoznanie onkologiczne
=================================================================================================-->

<xsl:template name="rozpoznanie-onkol">

  <xsl:if test="rozpoznanie-onkol">

    <div id="rozp-icd10">

      <h2>Rozpoznanie onkologiczne po wypisie</h2>

      <table>

        <col/>
        <xsl:if test="rozpoznanie-onkol/@opis">
          <col/>
        </xsl:if>
        <col width="60"/>
        <col width="90"/>

        <!-- rozpoznanie onkologiczne wg ICD-10 -->

        <tr>
          <th>Nazwa</th>
          <xsl:if test="rozpoznanie-onkol/@opis">
            <th>Opis</th>
          </xsl:if>
          <th>Kod</th>
          <th>Data badania</th>
        </tr>

        <tr>
          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="rozpoznanie-onkol/@nazwa"/>
          </xsl:call-template>

          <xsl:if test="rozpoznanie-onkol/@opis">
            <xsl:call-template name="text-td">
              <xsl:with-param name="value" select="rozpoznanie-onkol/@opis"/>
            </xsl:call-template>
          </xsl:if>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="rozpoznanie-onkol/@kod"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="rozpoznanie-onkol/@data"/>
          </xsl:call-template>
        </tr>

      </table>

    </div>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  zast-lecz-uwagi
=================================================================================================-->

<xsl:template name="zast-lecz-uwagi">

  <xsl:if test="hospitalizacja/@leczenie">

    <div id="zast-lecz">

      <h2>Zastosowane leczenie  dodatkowe uwagi</h2>

      <xsl:call-template name="text-table">
        <xsl:with-param name="value" select="hospitalizacja/@leczenie"/>
      </xsl:call-template>

    </div>

  </xsl:if>

</xsl:template>

<!--====================================================================================================================
  zabiegi wykonane
=====================================================================================================================-->

<xsl:template name="zabiegi-wykonane">

  <xsl:if test="zabiegi-wykonane/node()">

    <h2 class="wypis">Wykonane zabiegi</h2>

    <table>

      <col width="80%"/>
      <col width="20%"/>

      <th>Nazwa</th>
      <th>Liczba</th>

      <xsl:for-each select="zabiegi-wykonane/zabieg">

        <tr>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@nazwa"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="@liczba"/>
            <xsl:with-param name="align" select="'right'"/>
          </xsl:call-template>

        </tr>

      </xsl:for-each>

    </table>

  </xsl:if>

</xsl:template>

<!--================================================================================================
  centyle
=================================================================================================-->

<xsl:template name="centyle">

  <xsl:if test="hospitalizacja/@bmi-centyl or hospitalizacja/@waga-centyl or hospitalizacja/@wzrost-centyl">

    <div id="centyle">

      <h2>Centyle</h2>

      <table>
        <tr>
          <th>Wzrost (cm)</th>
          <th>Wzrost - centyl</th>
          <th>Waga (kg)</th>
          <th>Waga - centyl</th>
          <th>BMI</th>
          <th>BMI - centyl</th>
        </tr>

        <tr>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="hospitalizacja/@wzrost"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="hospitalizacja/@wzrost-centyl"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="hospitalizacja/@waga"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="hospitalizacja/@waga-centyl"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="hospitalizacja/@bmi"/>
          </xsl:call-template>

          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="hospitalizacja/@bmi-centyl"/>
          </xsl:call-template>

        </tr>

      </table>

    </div>

  </xsl:if>

</xsl:template>

<!--===============================================================================================
  dokumenty-dodatkowe
================================================================================================-->

<xsl:template name="dokumenty-dodatkowe">

  <xsl:if test="dokumenty-dodatkowe">
    <h2>Dokumenty dodatkowe</h2>
    <table>
      <xsl:if test="dokumenty-dodatkowe/@czy-wypis-piel">
        <tr>
          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="'Wypis pielgniarski'"/>
          </xsl:call-template>
        </tr>
      </xsl:if>
      <xsl:if test="dokumenty-dodatkowe/@czy-list-do-poz">
        <tr>
          <xsl:call-template name="text-td">
            <xsl:with-param name="value" select="'List do POZ'"/>
          </xsl:call-template>
        </tr>
      </xsl:if>
    </table>
  </xsl:if>

</xsl:template>

</xsl:stylesheet>